clear all;
close all;

%% Plot strip band structure

load('bandstructure_data.mat');

figure(1);
% clf;
subplot2 = subplot(1,1,1);
set(subplot2,'FontSize',16,'XTick',[-pi/geom.mech.amech -2*pi/(3*geom.mech.amech) 0 2*pi/(3*geom.mech.amech) pi/geom.mech.amech],...
    'XTickLabel',{'-\pi', '-2\pi/3', '0', '2\pi/3', '\pi'});

xlim(subplot2,[-pi/geom.mech.amech pi/geom.mech.amech]);
ylim(subplot2,[309.2e6 351.9e6]);

gap_line = [371*ones(1,4) linspace(371,359,10) 359*ones(1,6) ...
    linspace(359,355.2,4) 355.2*ones(1,5) 355.06]*1e6;
energy = lines_shift(Eval_mech.bands, gap_line);

hold on;
box on;

% plot(sqrt(Eval_mech.kx(1:size(gap_line, 2)).^2 + Eval_mech.ky(1:size(gap_line, 2)).^2), gap_line, 'Color', 'red', 'LineStyle', 'none','Marker', '.', 'MarkerFaceColor', 'red', 'MarkerSize', 10);

% To check the bandgap
% for i=1:size(Eval_mech.bands, 1)
%     for j=1:size(Eval_mech.bands, 2)
%         plot(sqrt(Eval_mech.kx(j)^2 + Eval_mech.ky(j)^2), real(Eval_mech.bands(i,j)), 'Color', 'blue', 'LineStyle', 'none','Marker', '.', 'MarkerFaceColor', 'blue', 'MarkerSize', 10);
%         plot(-sqrt(Eval_mech.kx(j)^2 + Eval_mech.ky(j)^2), real(Eval_mech.bands(i,j)), 'Color', 'blue', 'LineStyle', 'none','Marker', '.', 'MarkerFaceColor', 'blue', 'MarkerSize', 10);
%     end
% end

% Band structure
for i=1:size(energy,1)
    plot(sqrt(Eval_mech.kx.^2 + Eval_mech.ky.^2), real(energy(i,:)), 'Color', 'blue', 'LineWidth', 3);
    plot(-sqrt(Eval_mech.kx.^2 + Eval_mech.ky.^2), real(energy(i,:)), 'Color', 'blue', 'LineWidth', 3);
end

% Physical edge state modes
colour_edge_mode = [146/256, 146/256, 146/256, 1];

% Physical edge mode 1
plot(sqrt(Eval_mech.kx(1:22).^2 + Eval_mech.ky(1:22).^2), real(energy(18,(1:22))), 'Color', colour_edge_mode, 'LineWidth', 3);
plot(-sqrt(Eval_mech.kx(1:22).^2 + Eval_mech.ky(1:22).^2), real(energy(18,(1:22))), 'Color', colour_edge_mode, 'LineWidth', 3);

plot(sqrt(Eval_mech.kx(22:30).^2 + Eval_mech.ky(22:30).^2), real(energy(19,(22:30))), 'Color', colour_edge_mode, 'LineWidth', 3);
plot(-sqrt(Eval_mech.kx(22:30).^2 + Eval_mech.ky(22:30).^2), real(energy(19,(22:30))), 'Color', colour_edge_mode, 'LineWidth', 3);

% % Physical edge mode 2
plot(sqrt(Eval_mech.kx(1:18).^2 + Eval_mech.ky(1:18).^2), real(energy(19,1:18)), 'Color', colour_edge_mode, 'LineWidth', 3);
plot(-sqrt(Eval_mech.kx(1:18).^2 + Eval_mech.ky(1:18).^2), real(energy(19,1:18)), 'Color', colour_edge_mode, 'LineWidth', 3);

plot(sqrt(Eval_mech.kx(18:30).^2 + Eval_mech.ky(18:30).^2), real(energy(20,18:30)), 'Color', colour_edge_mode, 'LineWidth', 3);
plot(-sqrt(Eval_mech.kx(18:30).^2 + Eval_mech.ky(18:30).^2), real(energy(20,18:30)), 'Color', colour_edge_mode, 'LineWidth', 3);

% Physical edge mode 3
plot(sqrt(Eval_mech.kx(1:8).^2 + Eval_mech.ky(1:8).^2), real(energy(20,1:8)), 'Color', colour_edge_mode, 'LineWidth', 3);
plot(-sqrt(Eval_mech.kx(1:8).^2 + Eval_mech.ky(1:8).^2), real(energy(20,1:8)), 'Color', colour_edge_mode, 'LineWidth', 3);

plot(sqrt(Eval_mech.kx(8:11).^2 + Eval_mech.ky(8:11).^2), real(energy(21,8:11)), 'Color', colour_edge_mode, 'LineWidth', 3);
plot(-sqrt(Eval_mech.kx(8:11).^2 + Eval_mech.ky(8:11).^2), real(energy(21,8:11)), 'Color', colour_edge_mode, 'LineWidth', 3);

plot(sqrt(Eval_mech.kx(26:30).^2 + Eval_mech.ky(26:30).^2), real(energy(21,26:30)), 'Color', colour_edge_mode, 'LineWidth', 3);
plot(-sqrt(Eval_mech.kx(26:30).^2 + Eval_mech.ky(26:30).^2), real(energy(21,26:30)), 'Color', colour_edge_mode, 'LineWidth', 3);

% Physical edge mode 4
plot(sqrt(Eval_mech.kx(1:7).^2 + Eval_mech.ky(1:7).^2), real(energy(21,1:7)), 'Color', colour_edge_mode, 'LineWidth', 3);
plot(-sqrt(Eval_mech.kx(1:7).^2 + Eval_mech.ky(1:7).^2), real(energy(21,1:7)), 'Color', colour_edge_mode, 'LineWidth', 3);

plot(sqrt(Eval_mech.kx(7:10).^2 + Eval_mech.ky(7:10).^2), real(energy(22,7:10)), 'Color', colour_edge_mode, 'LineWidth', 3);
plot(-sqrt(Eval_mech.kx(7:10).^2 + Eval_mech.ky(7:10).^2), real(energy(22,7:10)), 'Color', colour_edge_mode, 'LineWidth', 3);

plot(sqrt(Eval_mech.kx(27:30).^2 + Eval_mech.ky(27:30).^2), real(energy(22,27:30)), 'Color', colour_edge_mode, 'LineWidth', 3);
plot(-sqrt(Eval_mech.kx(27:30).^2 + Eval_mech.ky(27:30).^2), real(energy(22,27:30)), 'Color', colour_edge_mode, 'LineWidth', 3);